program Project1;

{$MODE OBJFPC}{$H+}{$J-}
{$MINFPCONSTPREC 64}
{$CODEPAGE UTF8}

uses
  SysUtils, FileInfo;

var
  VerInfo     : TVersionInfo;
  FileVerInfo : TFileVersionInfo;

{$R VerInfo.rc}

begin

  SetMultiByteConversionCodePage(CP_UTF8);
  SetMultiByteRTLFileSystemCodePage(CP_UTF8);

  try
    VerInfo     := TVersionInfo.Create;           // 「FILEVERSION」の情報。
    FileVerInfo := TFileVersionInfo.Create(Nil);  // 「BLOCK "StringFileInfo"」の情報。
    try
      VerInfo.Load(HINSTANCE);  // バージョン情報リソースがないと例外が発生する。
    except
      WriteLn;
      WriteLn('エラー: バージョン情報がありません。');
      ExitCode := 1;
      Exit;
    end;
    WriteLn;
    { 「FILEVERSION」の情報を出力 }
    with VerInfo.FixedInfo do
    begin
      WriteLn(
        ExtractFileName(ParamStr(0)), ' Ver.',
        FileVersion[0], '.',
        FileVersion[1], '.',
        FileVersion[2], '.',
        FileVersion[3]
      );
    end;
    WriteLn;;
    { 「BLOCK "StringFileInfo"」の情報を出力 }
    FileVerInfo.ReadFileInfo;
    with FileVerInfo.VersionStrings do
    begin
      WriteLn('Company           : ', Values['CompanyName']);
      WriteLn('File description  : ', Values['FileDescription']);
      WriteLn('File version      : ', Values['FileVersion']);
      WriteLn('Internal name     : ', Values['InternalName']);
      WriteLn('Legal copyright   : ', Values['LegalCopyright']);
      WriteLn('Legal trademarks  : ', Values['LegalTrademarks']);
      WriteLn('Original filename : ', Values['OriginalFilename']);
      WriteLn('Product name      : ', Values['ProductName']);
      WriteLn('Product version   : ', Values['ProductVersion']);
      WriteLn('Comments          : ', Values['Comments']);
    end;
    WriteLn;
  finally
    FileVerInfo.Free;
    VerInfo.Free;
  end;

end.
